<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html"/>
	<xsl:decimal-format name="european" decimal-separator="," grouping-separator="."/>
	<xsl:template match="/">
		<html>
			<head>
				<title>CONTO DEL BILANCIO PER COMUNI</title>
				<style type="text/css">
	td { font-family: tahoma; font-size: 7pt; color: #000000; font-weight: normal;}
	td.intest { font-size: 9pt;}
	table.tabella1 { width: 849px; border-collapse: collapse; border-width: 0}
	td.indent1 {padding-left: 15px}
	td.indent2 {padding-left: 30px}
	td.stampa1 { width: 84px }
</style>
				<style media="print" type="text/css">
	td { font-family: tahoma; font-size: 5pt; color: #000000; }
	table.tabella1 { width: 729px }
	td.stampa1 { width: 64px }
</style>
			</head>
			<body bgcolor="#FFFFFF" text="#000000">
				<table width="100%" border="0" cellspacing="0" cellpadding="3">
					<tr>
						<td align="center" colspan="3" class="intest">
							<p>
								<b>CONTO DEL BILANCIO<br/>
								</b>
								<b>PER COMUNI<br/>
								</b>
							</p>
						</td>
					</tr>
					<tr>
						<td width="290">ESERCIZIO: <xsl:value-of select="//Copertina/Esercizio"/> </td>
    <td width="466">ENTE: <xsl:value-of select="//Copertina/NomeEnte"/></td>
    <td width="229">SIGLA PROVINCIA: <xsl:value-of select="//Copertina/Provincia"/></td>
  </tr>
  <tr> 
    <td width="290">CODICE ISTAT: <xsl:value-of select="//Copertina/CodiceIstat"/>
</td>
    <td width="466">DELIBERA DI APPROVAZIONE: N°<xsl:value-of select="//Copertina/NumDelibera"/></td>
    <xsl:variable name="abitanti"  select ="//Copertina/NumAbitanti" />
    <td width="229">NUMERO DI ABITANTI: <xsl:value-of select ="format-number ($abitanti, '#.###.###.###.###.##0', 'european') "/>
    </td>
  </tr>
  <tr> 
    <td width="290">PARTITA IVA: <xsl:value-of select="//Copertina/PartitaIVA"/></td>
    <td width="466">DEL: <xsl:value-of select="//Copertina/DataDelibera/Giorno"/>/<xsl:value-of select="//Copertina/DataDelibera/Mese"/>/<xsl:value-of select="//Copertina/DataDelibera/Anno"/></td>
    	
    <xsl:variable name="superficie"  select ="//Copertina/Superficie" />
    <td width="229">
    SUPERFICIE (kmq): <xsl:value-of select ="//Copertina/Superficie"/>
    </td>
					</tr>
				</table>
				<br/>
				<table width="100%" border="0" cellspacing="0" cellpadding="3">
					<tr>
						<td align="center">
							<b>GESTIONE DELLE ENTRATE</b>
						</td>
					</tr>
				</table>
				<table class="tabella1" border="1" cellspacing="0" cellpadding="2" bordercolor="#000000">
					<tr>
						<td rowspan="5" width="300" align="center">DESCRIZIONE<br/>
		(con i dati della classificazione: Codice - Risorsa - Capitolo)</td>
						<td rowspan="3" valign="bottom" align="center" width="25">RS</td>
						<td align="center" rowspan="2" class="stampa1">Residui conservati e Stanziamenti 
		definitivi di bilancio</td>
						<td rowspan="5" align="center" valign="middle" class="stampa1">N° di riferimento 
		allo svolgimento</td>
						<td align="center" class="stampa1">Conto del tesoriere</td>
						<td align="center" class="stampa1">Determinazione dei residui</td>
						<td rowspan="2" align="center" valign="middle" class="stampa1">Accertamenti</td>
						<td rowspan="2" align="center" class="stampa1">Maggiori o minori entrate</td>
					</tr>
					<tr>
						<td align="center" class="stampa1">Riscossioni</td>
						<td align="center" class="stampa1">Residui da riportare</td>
					</tr>
					<tr>
						<td align="center" class="stampa1">Residui (A)</td>
						<td align="center" class="stampa1">Residui (B)</td>
						<td align="center" class="stampa1">Residui (C=D-B)</td>
						<td class="stampa1" align="center" valign="middle">Residui (D)</td>
						<td align="center" class="stampa1">(E=D-A)<br/>
		  (E=A-D)(*)</td>
					</tr>
					<tr>
						<td width="25" align="center">CP</td>
						<td align="center" class="stampa1">Competenza (F)</td>
						<td align="center" class="stampa1">Competenza (G)</td>
						<td align="center" class="stampa1">Competenza (H)</td>
						<td align="center" class="stampa1">Competenza (I=G+H)</td>
						<td align="center" rowspan="2" class="stampa1">(L=I-F)<br/>
		  (L=F-I) </td>
					</tr>
					<tr>
						<td width="25" align="center">T.</td>
						<td align="center" class="stampa1">Totale (M)</td>
						<td align="center" class="stampa1">Totale (N)</td>
						<td align="center" class="stampa1">Residui al 31 dicembre (O=C+H)</td>
						<td align="center" class="stampa1">Accertamenti al 31 dicembre (P=D+I)</td>
					</tr>
					<tr valign="bottom">
						<td>TITOLO I - ENTRATE TRIBUTARIE</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						

					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 1 - IMPOSTE</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloI/Categoria1/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
					</tr>
					<tr valign="bottom">
						<td>&nbsp;</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 1</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloI/Categoria1/Totale"/>
						</xsl:call-template>

												
			

					</tr>
					<tr valign="bottom">
						<td>&nbsp;</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 2 - TASSE</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
												
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloI/Categoria2/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>

					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 2</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
												
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloI/Categoria2/Totale"/>
						</xsl:call-template>

						
						
					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 3 - TRIBUTI SPECIALI ED ALTRE ENTRATE TRIBUTARIE PROPRIE</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloI/Categoria3/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 3</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
												
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloI/Categoria3/Totale"/>
						</xsl:call-template>
						
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE TITOLO I</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						

						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloI/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td>TITOLO II - ENTRATE DERIVANTI DA CONTRIBUTI E TRASFERIMENTI CORRENTI DELLO STATO, DELLA REGIONE E DI ALTRI ENTI PUBBLICI ANCHE IN RAPPORTO ALL'ESERCIZIO DI FUNZIONI DELEGATE DALLA REGIONE</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						

					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 1 - CONTRIBUTI E TRASFERIMENTI CORRENTI DALLO STATO</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloII/Categoria1/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 1</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloII/Categoria1/Totale"/>
						</xsl:call-template>
												
					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 2 - CONTRIBUTI E TRASFERIMENTI CORRENTI DALLA REGIONE</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloII/Categoria2/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 2</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloII/Categoria2/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 3 - CONTRIBUTI E TRASFERIMENTI DALLA REGIONE PER FUNZIONI DELEGATE</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
												
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloII/Categoria3/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 3</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloII/Categoria3/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 4 - CONTRIBUTI E TRASFERIMENTI DA PARTE DI ORGANISMI COMUNITARI ED INTERNAZIONALI</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloII/Categoria4/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 4</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloII/Categoria4/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 5 - CONTRIBUTI E TRASFERIMENTI CORRENTI DA ALTRI ENTI DEL SETTORE PUBBLICO</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloII/Categoria5/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 5</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloII/Categoria5/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE TITOLO II</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloII/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td>TITOLO III - ENTRATE EXTRATRIBUTARIE</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 1 - PROVENTI DEI SERVIZI PUBBLICI</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloIII/Categoria1/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 1</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloIII/Categoria1/Totale"/>
						</xsl:call-template>
						
					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 2 - PROVENTI DEI BENI DELL'ENTE</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloIII/Categoria2/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 2</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloIII/Categoria2/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 3 - INTERESSI SU ANTICIPAZIONI E CREDITI</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
							<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloIII/Categoria3/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 3</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloIII/Categoria3/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 4 - UTILI NETTI DELLE AZIENDE SPECIALI E PARTECIPATE, DIVIDENDI DI SOCIETA' </td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloIII/Categoria4/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 4</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						

						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloIII/Categoria4/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 5 - PROVENTI DIVERSI</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloIII/Categoria5/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
						
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 5</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloIII/Categoria5/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE TITOLO III</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloIII/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td>TITOLO IV - ENTRATE DERIVANTI DA ALIENAZIONI, DA TRASFERIMENTI DI CAPITALE E DA RISCOSSIONE DI CREDITI</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 1 - ALIENAZIONE DI BENI PATRIMONIALI</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloIV/Categoria1/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 1</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloIV/Categoria1/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 2 - TRASFERIMENTI DI CAPITALE DALLO STATO</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloIV/Categoria2/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 2</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloIV/Categoria2/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 3 - TRASFERIMENTI DI CAPITALE DALLA REGIONE</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloIV/Categoria3/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 3</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloIV/Categoria3/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 4 - TRASFERIMENTI DI CAPITALE DA ALTRI ENTI DEL SETTORE PUBBLICO</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloIV/Categoria4/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 4</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						

						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloIV/Categoria4/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 5 - TRASFERIMENTI DI CAPITALE DA ALTRI SOGGETTI</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloIV/Categoria5/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 5</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloIV/Categoria5/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 6 - RISCOSSIONE DI CREDITI</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloIV/Categoria6/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 6</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloIV/Categoria6/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE TITOLO IV</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloIV/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td>TITOLO V - ENTRATE DERIVANTI DA ACCENSIONE DI PRESTITI</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 1 - ANTICIPAZIONI DI CASSA</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloV/Categoria1/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 1</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloV/Categoria1/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 2 - FINANZIAMENTI A BREVE TERMINE</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloV/Categoria2/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 2</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloV/Categoria2/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 3 - ASSUNZIONE DI MUTUI E PRESTITI</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloV/Categoria3/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 3</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloV/Categoria3/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td class="indent1">CATEGORIA 4 - EMISSIONE DI PRESTITI OBBLIGAZIONARI</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:for-each select="//GestioneEntrate/TotaleGenerale/TitoloV/Categoria4/Risorsa">
							<xsl:call-template name="ScriviRigheRisorsa">
								<xsl:with-param name="RigaRisorsa" select="child::node()"/>
							</xsl:call-template>
						</xsl:for-each>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE CATEGORIA 4</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloV/Categoria4/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE TITOLO V</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloV/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td>TITOLO VI - ENTRATE DA SERVIZI PER CONTO DI TERZI</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
					</tr>
					<tr valign="bottom">
						<td class="indent1">RITENUTE PREVIDENZIALI ED ASSISTENZIALI AL PERSONALE</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloVI/RitenutePrevidenziali"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td class="indent1">RITENUTE ERARIALI</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloVI/RitenuteErariali"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td class="indent1">ALTRE RITENUTE AL PERSONALE PER CONTO DI TERZI</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloVI/AltreRitenute"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td class="indent1">DEPOSITI CAUZIONALI</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloVI/DepositiCauzionali"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td class="indent1">RIMBORSO SPESE PER SERVIZI PER CONTO DI TERZI</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloVI/RimborsoSpese"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td class="indent1">RIMBORSO DI ANTICIPAZIONE DI FONDI PER IL SERVIZIO ECONOMATO</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloVI/RimborsoAnticipazioni"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td class="indent1">DEPOSITI PER SPESE CONTRATTUALI</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloVI/DepositoSpeseContrattuali"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE TITOLO VI</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
												
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/TitoloVI/Totale"/>
						</xsl:call-template>
					</tr>
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE GENERALE</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGenerale/Totale"/>
						</xsl:call-template>
					</tr>
					<tr>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>					
					</tr>
					<tr valign="bottom">
						<td align="right">
							AVANZO DI AMMINISTRAZIONE
						</td>
						<td align="center">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//GestioneEntrate/Avanzo"/>
						</xsl:call-template>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>						
					</tr>
					<tr>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>					
					</tr>
					
					<tr valign="bottom">
						<td align="right">
							FONDO DI CASSA AL 1° GENNAIO
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<xsl:call-template name="TuttiNodi">
							<xsl:with-param name="Nodo" select="//GestioneEntrate/Fondo"/>
						</xsl:call-template>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>						
					</tr>
					<tr>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>					
					</tr>
					
					<tr valign="bottom">
						<td align="right">
							<b>TOTALE GENERALE DELLE ENTRATE</b>
						</td>
						<td align="center">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						<td align="right">&nbsp;</td>
						
						<xsl:call-template name="ScriviRigheRisorsa">
							<xsl:with-param name="RigaRisorsa" select="//GestioneEntrate/TotaleGeneraleEntrate"/>
						</xsl:call-template>
					</tr>
				</table>
				<table width="100%" border="0" cellspacing="0" cellpadding="3">
  					<tr> 
  						<td>(*) Motivi del verificarsi dei minori residui attivi: Insussistenti (INS)</td>
 					 </tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="ScriviRigheRisorsa">
		<xsl:param name="RigaRisorsa"/>
		<xsl:param name="ResiduiConservatiRS_Virgola" select="$RigaRisorsa/ResiduiConservatiRS"/>
		<xsl:param name="ResiduiConservatiRS_Punto" select="translate($ResiduiConservatiRS_Virgola,  ','  , '.' ) "/>
		<xsl:param name="ResiduiConservatiRS" select="number($ResiduiConservatiRS_Punto)"/>
		<xsl:param name="ResiduiConservatiCP_Virgola" select="$RigaRisorsa/ResiduiConservatiCP"/>
		<xsl:param name="ResiduiConservatiCP_Punto" select="translate($ResiduiConservatiCP_Virgola,  ','  , '.' ) "/>
		<xsl:param name="ResiduiConservatiCP" select="number($ResiduiConservatiCP_Punto)"/>
		<xsl:param name="ResiduiConservatiT_Virgola" select="$RigaRisorsa/ResiduiConservatiT"/>
		<xsl:param name="ResiduiConservatiT_Punto" select="translate($ResiduiConservatiT_Virgola,  ','  , '.' ) "/>
		<xsl:param name="ResiduiConservatiT" select="number($ResiduiConservatiT_Punto)"/>
		

		<xsl:param name="RiscossioniRS_Virgola" select="$RigaRisorsa/RiscossioniRS"/>
		<xsl:param name="RiscossioniRS_Punto" select="translate($RiscossioniRS_Virgola,  ','  , '.' ) "/>
		<xsl:param name="RiscossioniRS" select="number($RiscossioniRS_Punto)"/>
		<xsl:param name="RiscossioniCP_Virgola" select="$RigaRisorsa/RiscossioniCP"/>
		<xsl:param name="RiscossioniCP_Punto" select="translate($RiscossioniCP_Virgola,  ','  , '.' ) "/>
		<xsl:param name="RiscossioniCP" select="number($RiscossioniCP_Punto)"/>
		<xsl:param name="RiscossioniT_Virgola" select="$RigaRisorsa/RiscossioniT"/>
		<xsl:param name="RiscossioniT_Punto" select="translate($RiscossioniT_Virgola,  ','  , '.' ) "/>
		<xsl:param name="RiscossioniT" select="number($RiscossioniT_Punto)"/>
		<xsl:param name="ResiduiDaRiportareRS_Virgola" select="$RigaRisorsa/ResiduiDaRiportareRS"/>
		<xsl:param name="ResiduiDaRiportareRS_Punto" select="translate($ResiduiDaRiportareRS_Virgola,  ','  , '.' ) "/>
		<xsl:param name="ResiduiDaRiportareRS" select="number($ResiduiDaRiportareRS_Punto)"/>
		<xsl:param name="ResiduiDaRiportareCP_Virgola" select="$RigaRisorsa/ResiduiDaRiportareCP"/>
		<xsl:param name="ResiduiDaRiportareCP_Punto" select="translate($ResiduiDaRiportareCP_Virgola,  ','  , '.' ) "/>
		<xsl:param name="ResiduiDaRiportareCP" select="number($ResiduiDaRiportareCP_Punto)"/>
		<xsl:param name="ResiduiDaRiportareT_Virgola" select="$RigaRisorsa/ResiduiDaRiportareT"/>
		<xsl:param name="ResiduiDaRiportareT_Punto" select="translate($ResiduiDaRiportareT_Virgola,  ','  , '.' ) "/>
		<xsl:param name="ResiduiDaRiportareT" select="number($ResiduiDaRiportareT_Punto)"/>
		<xsl:param name="AccertamentiRS_Virgola" select="$RigaRisorsa/AccertamentiRS"/>
		<xsl:param name="AccertamentiRS_Punto" select="translate($AccertamentiRS_Virgola,  ','  , '.' ) "/>
		<xsl:param name="AccertamentiRS" select="number($AccertamentiRS_Punto)"/>
		<xsl:param name="AccertamentiCP_Virgola" select="$RigaRisorsa/AccertamentiCP"/>
		<xsl:param name="AccertamentiCP_Punto" select="translate($AccertamentiCP_Virgola,  ','  , '.' ) "/>
		<xsl:param name="AccertamentiCP" select="number($AccertamentiCP_Punto)"/>
		
		<xsl:param name="AccertamentiT_Virgola" select="$RigaRisorsa/AccertamentiT"/>
		<xsl:param name="AccertamentiT_Punto" select="translate($AccertamentiT_Virgola,  ','  , '.' ) "/>
		<xsl:param name="AccertamentiT" select="number($AccertamentiT_Punto)"/>
		
				
		
		<xsl:param name="RS_Virgola" select="$RigaRisorsa/MagMinRS"/>
		<xsl:param name="RS_Punto" select="translate($RS_Virgola,  ','  , '.' ) "/>
		<xsl:param name="RS" select="number($RS_Punto)"/>

		<xsl:param name="CP_Virgola" select="$RigaRisorsa/MagMinCP"/>
		<xsl:param name="CP_Punto" select="translate($CP_Virgola,  ','  , '.' ) "/>
		<xsl:param name="CP" select="number($CP_Punto)"/>

		
		
			<tr>
				<td class="indent2">
					<xsl:value-of select="Descrizione"/>
				</td>
				<td align="right">RS</td>
				<td align="right">
					<xsl:value-of select="format-number ($ResiduiConservatiRS, '#.###.###.###.###.##0,00', 'european')"/>
				</td>
				<td align="right">
					<xsl:value-of select="$RigaRisorsa/NRif"/>
				</td>
				<td align="right">
					<xsl:value-of select="format-number ($RiscossioniRS, '#.###.###.###.###.##0,00', 'european')"/>
				</td>
				<td align="right">
					<xsl:value-of select="format-number ($ResiduiDaRiportareRS, '#.###.###.###.###.##0,00', 'european')"/>
				</td>
				<td align="right">
					<xsl:value-of select="format-number ($AccertamentiRS, '#.###.###.###.###.##0,00', 'european')"/>
				</td>
				<td align="right">
					<xsl:value-of select="format-number ($RS, '#.###.###.###.###.##0,00', 'european') "/>
				</td>
				
			</tr>
			<tr valign="bottom">
				<td>&nbsp;</td>
				<td align="right">CP</td>
				<td align="right">
					<xsl:value-of select="format-number ($ResiduiConservatiCP, '#.###.###.###.###.##0,00', 'european')"/>
				</td>
				<td align="right">&nbsp;</td>
				<td align="right">
					<xsl:value-of select="format-number ($RiscossioniCP, '#.###.###.###.###.##0,00', 'european')"/>
				</td>
				<td align="right">
					<xsl:value-of select="format-number ($ResiduiDaRiportareCP, '#.###.###.###.###.##0,00', 'european')"/>
				</td>
				<td align="right">
					<xsl:value-of select="format-number ($AccertamentiCP, '#.###.###.###.###.##0,00', 'european')"/>
				</td>
				<td align="right">
					<xsl:value-of select="format-number ($CP, '#.###.###.###.###.##0,00', 'european')"/>
				</td>
				
			</tr>
			<tr valign="bottom">
				<td>&nbsp;</td>
				<td align="right">T</td>
				<td align="right">
					<xsl:value-of select="translate(format-number ($ResiduiConservatiT,'#.###.###.###.###.##0,00', 'european'),'NaN' , '')"/>
				</td>
				<td align="right">&nbsp;</td>
				
								
				<td align="right">
					<xsl:value-of select="format-number ($RiscossioniT, '#.###.###.###.###.##0,00', 'european')"/>
				</td>
				<td align="right">
					<xsl:value-of select="format-number ($ResiduiDaRiportareT, '#.###.###.###.###.##0,00', 'european')"/>
				</td>
				<td align="right">
					<xsl:value-of select="format-number ($AccertamentiT, '#.###.###.###.###.##0,00', 'european')"/>
				</td>
				<td align="right">&nbsp;</td>
				
			</tr>
	</xsl:template>
	
	<xsl:template name="formatto">
		<xsl:param name="Importo"/>
		<td align="right" valign="bottom">
			<xsl:value-of select="translate(format-number (number(translate($Importo,  ','  , '.' )),'#.###.###.###.###.##0,00', 'european'),'NaN','') "/>
		</td>
	</xsl:template>

	<xsl:template name="TuttiNodi">
		<xsl:param name="Nodo"/>
		<xsl:for-each select="$Nodo/child::node()">
			<xsl:call-template name="formatto">
				<xsl:with-param name="Importo">
					<xsl:value-of select="current()"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
